(function () {
    var app = angular.module('inventory', []);

    app.directive('inventory', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/inventory.html',
            scope: {},
            controller: function ($rootScope, $scope) {
                let ctrl = this;

                let loadInventory = () => {
                    ctrl.stacks = _.orderBy(Object.keys($rootScope.settings.inventory).map(componentName => {
                        let component = Components.find(x => x.name == componentName);
                        return {
                            order: Helpers.GetIndexByObject(component.employeeLevel),
                            component: component,
                            amount: $rootScope.settings.inventory[componentName]
                        }
                    }), ['component.type', 'component.employeeTypeName', 'order']);
                };

                $scope.$on(GameEvents.InventoryChange, () => {
                    loadInventory();
                });
                loadInventory();
            },
            controllerAs: 'ctrl'
        };
    });
})();
